#include "General.h"
#include "ReservedSlots.h"
#include "ConnectionRequest.h"
#include "HashTemplateClass.h"
#include "cGameOptionsEvent.h"
#include "HashTemplateIterator.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

// TODO:
// -Add PLIMIT console command replacement

HashTemplateClass<StringClass, int> ReservedNamesTable;
int RealLimit = 0;
int OldLimit = 0;
bool FirstLoad = true;
bool AcceptingConnection = false;

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);
	Console_Input(buffer);
}

void Set_Fake_Player_Limit(int FakePlayerLimit)
{
	cGameData *GameData = The_Game();
	_asm
	{
		mov ecx, GameData
			lea ebx, [ecx+01F8h]
		mov eax, FakePlayerLimit
			mov [ebx], eax
	}

	int TestValue;

	_asm
	{
		mov ecx, GameData
			mov ebx, [ecx+01F8h]
		mov TestValue, ebx
	}

//	Console_Output("Fake Player Limit is = %d\n", TestValue);	// DEBUG CRAP
}

ReservedSlots::ReservedSlots()
{
	RegisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	RegisterEvent(EVENT_PLAYER_JOIN_HOOK,this);
	RegisterEvent(EVENT_GLOBAL_INI,this);

	addConnectionAcceptanceFilter(this);
}

ReservedSlots::~ReservedSlots()
{
	UnregisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	UnregisterEvent(EVENT_PLAYER_JOIN_HOOK,this);
	UnregisterEvent(EVENT_GLOBAL_INI,this);

	removeConnectionAcceptanceFilter(this);
}

void ReservedSlots::OnLoadGlobalINISettings(INIClass *SSGMIni)
{	
	int Count = SSGMIni->Entry_Count("ReservedSlots_ReservedList");
	for (int i = 0; i < Count; i++)
	{
		const char *Entry = SSGMIni->Get_Entry("ReservedSlots_ReservedList", i);
		StringClass Insert;
		SSGMIni->Get_String(Insert, "ReservedSlots_ReservedList", Entry);
		ReservedNamesTable.Insert(Insert, 1);
	}

	// DEBUG CRAP
/*	for (HashTemplateIterator<StringClass, int> iter(ReservedNamesTable); iter; ++iter)
	{
		Console_Output("ReservedNamesTable: %s\n", iter.getKey());
	} */
}

void ReservedSlots::OnPlayerJoin(int PlayerID,const char *PlayerName)
{
	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		cPlayer *p = PlayerIter->Data();

		if (p->IsActive)
		{
			Update_Game_Data(p->PlayerId);
		}
	}
}

void ReservedSlots::OnPlayerLeave(int PlayerID)
{
	if ( ( RealLimit-1) == OldLimit )
	{
//		Console_Output("Triggered setting everything to normal player limit\n"); // DEBUG CRAP
		
		Console("plimit %d", OldLimit);
		RealLimit = OldLimit;
		Set_Fake_Player_Limit(OldLimit);
	}
	else if ( RealLimit-1 > OldLimit )
	{
//		Console_Output("Triggered removing one reserved slot\n"); // DEBUG CRAP

		Console("plimit %d", RealLimit-1);
		RealLimit = The_Game()->Get_Max_Players();
		Set_Fake_Player_Limit(RealLimit-1);
	}
}

void ReservedSlots::OnLoadLevel()
{
	if (FirstLoad == true)
	{
		FirstLoad = false;
		RealLimit = The_Game()->Get_Max_Players();
		OldLimit = The_Game()->Get_Max_Players();
	}	
}

void ReservedSlots::handleInitiation(const ConnectionRequest& connectionRequest)
{
	AcceptingConnection = true;

	if ( The_Game()->Get_Max_Players()<= (The_Game()->Get_Current_Players()+1) )
	{
		Console("plimit %d", RealLimit+1);
		RealLimit = The_Game()->Get_Max_Players();
		Set_Fake_Player_Limit(RealLimit-1);
	}
}

ConnectionAcceptanceFilter::STATUS ReservedSlots::getStatus(const ConnectionRequest& connectionRequest, WideStringClass& refusalMessage)
{
//	Console_Output("Serial hash = %s\n", connectionRequest.clientSerialHash); // DEBUG CRAP

	if ( (RealLimit > OldLimit+1) && (!ReservedNamesTable.Exists(StringClass(connectionRequest.clientName))) )
	{
		refusalMessage = L"Game is full.";
		AcceptingConnection = false;
		return STATUS_REFUSING;
	} 
	AcceptingConnection = true;
	return STATUS_ACCEPTING;	
}

void Clean_Up_Connection_Attempt()
{
	// return if the limit is set to the same or less that was set at startup
	if ( RealLimit == OldLimit ) { return; } 
	// return if we accept the connection
	if ( AcceptingConnection == true ) { AcceptingConnection = false; return; }

	else
	{
		if (RealLimit > OldLimit)
		{
			Console("plimit %d", RealLimit-1);
			RealLimit = The_Game()->Get_Max_Players();
			Set_Fake_Player_Limit(RealLimit-1);
		}
		if (RealLimit < OldLimit)
		{
			Console("plimit %d", RealLimit+2);
			RealLimit = The_Game()->Get_Max_Players();
			Set_Fake_Player_Limit(RealLimit+1);
		}
	}
}

void ReservedSlots::handleTermination(const ConnectionRequest& connectionRequest)
{
//	Console_Output("Called handleTermination\n"); // DEBUG CRAP
	Clean_Up_Connection_Attempt();
}
void ReservedSlots::handleCancellation(const ConnectionRequest& connectionRequest)
{
//	Console_Output("Called handleCancellation\n"); // DEBUG CRAP
	Clean_Up_Connection_Attempt();
}

ReservedSlots reservedSlots;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &reservedSlots;
}
